function [data] = spinesim(ite)
%Randomly generate spine data
%Synatax:   [data] = spinesim(ite);
%Input:     ite = the number of iterations
%Output:    data = .raw is the raw data, and .histave is the histogram
%               average and .histsum is the histogram sum.

histsum = zeros(1,178100,'single');
histave = zeros(ite,178100,'single');
for i = 1:ite  %iterate through
    %raw = randi(178100,1,1007);
    raw = 1781.*(rand(1,1007));
    raw = sort(raw);
    rawdist = abs([0 raw] - [raw 0]);
    rawdist = rawdist(2:end-1);
    %data(i).raw = rawdist;
    histmp = single(hist(rawdist,178100));
    histsum = histsum+histmp;
    histave(i,:) = histmp;
end
histave = mean(histave);
data(1).histave = histave;
data(1).histsum = histsum;